

/* Copyright 1988-1991 UserLand Software, Inc.  All Rights Reserved.*/


#include "landinternal.h"



boolean landnoparamcallback (landcallback cb) {
	
	if (cb == nil) /*defensive driving*/
		return (false);
		
	#ifdef THINKC
	
		if (!CallPascalW (cb))
			return (false);
			
	#else
	
		if (!((tynoparamcallback) *cb) ())
			return (false);
			
	#endif
	
	return (true);
	} /*landnoparamcallback*/


boolean landverbrecordcallback (hdlverbrecord hverb, landcallback cb) {
	
	register boolean fl;
	
	if (cb == nil) /*defensive driving*/
		return (false);
		
	#ifdef THINKC
	
		fl = (CallPascalW (hverb, cb) != 0);	
		
	#else
	
		fl = ((tyverbrecordcallback) *cb) (hverb);
		
	#endif
	
	return (fl);
	} /*landverbrecordcallback*/
	

boolean landfilespeccallback (FSSpec *fs, landcallback cb) {
	
	register boolean fl;
	
	if (cb == nil) /*defensive driving*/
		return (false);
		
	#ifdef THINKC
	
		fl = (CallPascalW (fs, cb) != 0);
		
	#else
	
		fl = ((tyfilespeccallback) *cb) (fs);
		
	#endif
	
	return (fl);
	} /*landfilespeccallback*/
	

